<?php
/**
 * User Rejected
 *
 * @package     AutomatorWP\Integrations\WP_User_Manager\Triggers\User_Rejected
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_WP_User_Manager_User_Rejected extends AutomatorWP_Integration_Trigger {

    public $integration = 'wp_user_manager';
    public $trigger = 'wp_user_manager_user_rejected';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User account gets rejected', 'automatorwp-pro' ),
            'select_option'     => __( 'User account gets <strong>rejected</strong>', 'automatorwp-pro' ),
            'edit_label'        => __( 'User account gets rejected', 'automatorwp-pro' ),
            'log_label'         => __( 'User account gets rejected', 'automatorwp-pro' ),
            'action'            => 'wpumuv_before_user_rejection',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(),
            'tags'              => array()
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $user_id
     */
    public function listener( $user_id ) {

        automatorwp_trigger_event( array(
            'trigger' => $this->trigger,
            'user_id' => $user_id,
        ) );

    }

}

new AutomatorWP_WP_User_Manager_User_Rejected();